/*
Programme rddcarac
version 0.2

Pour tirer rapidement un personnage  Rve de Dragon,
jeu de rle original cr par Denis Gerfaud
RdD 1 dition, 2 dition et passage de l premire  la seconde

Attention, il utilise les caractres accentus franais
*/

// h oui, tout a sert ici

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//#include <time.h>
#include "cmdline.h" // ncessaire pour le triage des options

/*
Voici le fichier gengetopt que j'ai utilis qui m'a produit un squelette de programme (cmdline.c et cmdline.h)
Vous remarquerez que les accents franais et le ' ne passent pas
----------------------
# fichier perso0.2.ggo

package "rddcarac"
version "0.2"

option "in-file"	i "Fichier d entree"		string	no
option "out-file"	o "Fichier de sortie" 		string	no
option "seed"		s "Initialisation de rand"	int	no
-----------------------
*/

// Les exceptions

/*
#define MAUVAISEGRAINE 666
#define PASDEGRAINE 667

#include "exception.h"

except *_exceptions;
*/

// Dclarations usuelles (noms, etc)

//const char *entet1ed[]={"Nom\t","N  l\'heure d\t","Sexe\t","ge\t","Taille\t","Poids\t","Cheveux\t","Yeux\t","Signe particuliers\t"}; // en-tte 1 dition

const char *carac1ed[]={"Taille\t\t","Apparence\t","Constitution\t","Force\t\t","Agilit\t\t","Dextrit\t","Vue\t\t","Oue\t\t","Odorat\t\t","Got\t\t","Volont\t\t","Intellect\t","loquence\t","Empathie\t","Rve\t\t","Chance\t\t","Mle\t\t","Tir\t\t","Lancer\t\t","Drobe\t\t"}; // caracs 1 dition

// 0=Taille, 1=Apparence, 2=Constitution, 3=Force, 4=Agilit, 5=Dextrit, 6=Vue, 7=Oue, 8=Odorat, 9=Got, 10=Volont, 11=Intellect, 12=loquence, 13=Empathie, 14=Rve, 15=Chance, 16=Mle, 17=Tir, 18=Lancer, 19=Drobe

const char *mdfct1ed[]={/*"Points actuels de rve\t","Moral\t","Stress\t","Malus armure\t",*/"Encombrement\t","Sustentation\t","Vitesse\t\t","Bonus dom\t","FR Const\t","FT Const\t","FT Int\t\t","FT Dext\t\t","FT Agil\t\t","FR For\t\t","FT For\t\t","Endurance\t","Vie\t\t","Mort\t\t"}; // modificateurs 1 dition

// 0=Encombrement, 1=Sustentation, 2=Vitesse, 3=Bonus dom, 4=FR Const, 5=FT Const, 6=FT Int, 7=FT Dext, 8=FT Agil, 9=FR For, 10=FT For, 11=Endurance, 12=Vie, hi hi, 13=mort

//const char *cmptc1ed[]={gnagnagna}

//#define NBENTET1ED 9
#define NBCARAC1ED 20
#define NBMDFCT1ED 14

/*
Programme principal
*/

int main(int argc,char *argv[])
{
  int i, vcarac1ed[NBCARAC1ED] /*ventet1ed[NBENTET1ED],*/, vmdfct1ed[NBMDFCT1ED], graine, OK;
  int tailleplusforce, tailleplusagilite;
  char *nom;
  //  except *exceptions=NULL;

  struct gengetopt_args_info args_info;

  if (cmdline_parser (argc, argv, &args_info) != 0) // appel du trieur d'options
    exit(1) ;

  //  graine=creegraine(seed_given);

// valeur de la graine

  if(args_info.seed_given)
    graine=args_info.seed_arg % RAND_MAX;
  else
  {
    //    printf("%f",difftime(time(NULL),
    OK=0;
    while(OK==0)
      {
	printf("Entrez une graine ");
	scanf("%u",&graine);
	if(graine!=0)
          OK=1;
	else
	  printf("Ttt...\n");
      }
    OK=0;
    graine %= RAND_MAX;
    printf("graine entre\t%u\n",graine);
  }

// initialisation de la graine

  srand(floor ((double) graine));

  // Calcul des caractristiques

  for(i=0;i<NBCARAC1ED-4;i++)
    vcarac1ed[i]=floor(rand()*10.0/RAND_MAX)+6;

  // Nom du rveur

  if(args_info.file_given)
    nom=args_info.file_arg;
  else
    {
      printf("Nom du rveur\t");
      scanf("%s",&nom);
    }

  vcarac1ed[16]=(vcarac1ed[3]+vcarac1ed[4])/2; // Mle=floor((force+agilit)/2)
  vcarac1ed[17]=(vcarac1ed[5]+vcarac1ed[6])/2; // Tir=floor((vue+dextrit)/2)
  vcarac1ed[18]=(vcarac1ed[17]+vcarac1ed[3])/2; // Lancer=floor((tir+force)/2)
  vcarac1ed[19]=(21-vcarac1ed[0]+vcarac1ed[4])/2; // Drobe=floor((21-taille+agilit)/2)

  // Valeurs utiles pour le calcul des modificateurs

  tailleplusforce=vcarac1ed[3]+vcarac1ed[0];
  tailleplusagilite=vcarac1ed[0]+vcarac1ed[4];

  // les valeurs sont entires, c'est pourquoi je ne fais pas appel  floor
  // De plus, les valeurs sont calcules pour des humains, ie les caractristiques tant limites  6-15

  vmdfct1ed[0]=tailleplusforce/2; // encombrement=floor(force+taille)/2
  vmdfct1ed[1]=(vcarac1ed[0]+2)/4; // sustentation

  if((tailleplusagilite/2)<=7) // vitesse
    vmdfct1ed[2]=10;
  else if((tailleplusagilite/2)<=12)
    vmdfct1ed[2]=12;
  else
    vmdfct1ed[2]=14;

  if((tailleplusforce/2)<=9) // bonus aux dommages
    vmdfct1ed[3]=tailleplusforce/4-4;
  else
    vmdfct1ed[3]=tailleplusforce/4-5;

  vmdfct1ed[4]=vcarac1ed[2]/3; // FR Const
  vmdfct1ed[5]=10-(1+vcarac1ed[2])/2; // FT Const
  vmdfct1ed[6]=10-(1+vcarac1ed[11])/2; // FT Int
  vmdfct1ed[7]=10-(1+vcarac1ed[5])/2; // FT Dex
  vmdfct1ed[8]=10-(1+vcarac1ed[4])/2; // FT Agil
  vmdfct1ed[9]=vcarac1ed[3]/3; // FR For
  vmdfct1ed[10]=10-(1+vcarac1ed[3])/2; // FT For
  vmdfct1ed[12]=(vcarac1ed[0]+vcarac1ed[2]+1)/2; // points de vie=ceil((taille+const)/2)
  vmdfct1ed[11]=((vmdfct1ed[12]+vcarac1ed[10])>(vcarac1ed[0]+vcarac1ed[2])) ? vmdfct1ed[12]+vcarac1ed[10] : vcarac1ed[0]+vcarac1ed[2]; // endurance=max(vie+volont,constitution+taille)
  vmdfct1ed[13]=-vmdfct1ed[4]; // Mort  -FR Const

  // Affichage

  printf("\t%s\n\n",nom);

  for(i=0;i<NBCARAC1ED;i++)
    printf("%s%i\n",carac1ed[i],vcarac1ed[i]);

  for(i=0;i<NBMDFCT1ED;i++)
    printf("%s%i\n",mdfct1ed[i],vmdfct1ed[i]);
}
