#!/usr/bin/perl

#	English

# First of all:
# You should modify $DLDIR, $DLDOCDIR and $opt_dllang

# This program was written with the help of
# Jrme Quelin's article in GNU/Linux Mag #49

# He is used between doom and the player, you need options

# You must write a shell script for each doom world you want to play
# Example:

# #!/bin/bash
# exec doomloader --dlhard -file /where/is/PARALLEL.WAD -deh /where/is/PARALLEL.DEH -iwad /where/is/doom.wad --dlep 2

#	Franais

# Avant tout :
# Vous devriez modifier $DLDIR, $DLDOCDIR et $opt_dllang

# Ce programme a t crit grace  l'article de
# Jrme Quelin dans le n 49 de GNU/Linux Magazine

# Il sert d'intermdiaire entre l'utilisateur
# (qui lance par exemple hellrevealed.sh, qui n'est que
#  doomloader.pl --dlhard -file /ou/est/HR.WAD -iwad /ou/est/doom2.wad )
# et doom, il n'est donc pas  utiliser sans option.

# Il faut donc crire un fichier par monde dans lequel on veut jouer.
# Ce fichier automatise le chargement de fichiers wad, deh ou bex.
# Exemple, je veux jouer  The Parallel Dimension :
# Je cre un fichier bash  theparalleldimension  contenant :

# #!/bin/bash
# exec doomloader --dlhard -file /ou/est/PARALLEL.WAD -deh /ou/est/PARALLEL.DEH -iwad /ou/est/doom.wad --dlep 2

use strict;

use File::Basename;

our $opt_dlhelp = 0;
our $opt_dlversion = 0;
our $opt_dllicense = 0;
our $opt_dlmkrc = 0;
our $opt_dlconfig = " ";
our $opt_dlport = 'prboom';
our $opt_dltext = " ";
our $opt_dlhard = 0;
our $opt_dlfunny = 0;
our $opt_dltotal = 0;
our $opt_dlcoop = 0;
our $opt_dlnocoop = 0;
our $opt_dldm = 0;
our $opt_dlnodm = 0;
our $opt_dlep = " ";
our $opt_dllev = " ";
our $opt_dlavail = 0;
our $opt_dllang = "english";
our $opt_dllangavail = 0;
our $opt_dlwadinfo = 0;
our $opt_dlreadme = " ";
our $opt_dlmusic = 0;

use Getopt::Long;
Getopt::Long::Configure( "no_ignorecase" );

# case is important
# la casse est importante

Getopt::Long::Configure( "no_autoabbrev" );

# no abbreviation, doomloader must not eat the ports' options
# pas d'abbrviation, il faut que ceci reste compatible
# avec les options des ports de Doom

Getopt::Long::Configure( "pass_through" );

# to let the options like -iwad pass through
# pour laisser passer les options des ports de Doom comme -iwad

our $emptyargv = 0;
if ( @ARGV == "" )
{
	$emptyargv = 1;
}		

do "/etc/doomloader.rc";
do "$ENV{HOME}/.doomloader/doomloader.rc";

GetOptions( "dlhelp" => \$opt_dlhelp,		# help
	"dlversion" => \$opt_dlversion,		# version
	"dllicense" => \$opt_dllicense,		# license
	"dlmkrc" => \$opt_dlmkrc,		# make user rc files
	"dlconfig=s" => \$opt_dlconfig,		# an other config file
	"dlavail" => \$opt_dlavail,		# available ports
	"dlwadinfo" => \$opt_dlwadinfo,		# prints the wad readme
	"dlreadme=s" => \$opt_dlreadme,		# the readme files
	"dllang=s" => \$opt_dllang,		# which language
	"dllangavail" => \$opt_dllangavail,	# available languages
	"dlport=s" => \$opt_dlport,		# doom port
	"dlep=s" => \$opt_dlep,			# episode
	"dllev=s" => \$opt_dllev,		# level
	"dlmusic" => \$opt_dlmusic,		# a music only wad
	"dltext=s" => \$opt_dltext,		# additionnal text
	"dlhard" => \$opt_dlhard,		# hard?
	"dlfunny" => \$opt_dlfunny,		# funny?
	"dltotal" => \$opt_dltotal,		# total conversion?
	"dlcoop" => \$opt_dlcoop,		# for coop,
	"dlnocoop" => \$opt_dlnocoop,		# or not?
	"dldm" => \$opt_dldm,			# for deathmatch,
	"dlnodm" => \$opt_dlnodm );		# or not?


if ( $opt_dlconfig ne " " )
{
	do "$opt_dlconfig";
}

our $DLDIR="/usr/local/bin";
our $DLDOCDIR="/usr/local/share/doc/doomloader";
our $DLEDGEDIR="/usr/local/games/doom/edge";
our $DLLICENSEFILE="$DLDOCDIR/gpl.txt";
our $DLVERSION="0.9";
our $DLNAME=basename $0;
our @DLPORTLIST=('prboom','lxdoom','lsdoom','llxdoom','edge','quake-x11', 'quake2');
our @DLLANGAVAIL=('english','franais');

#our $testlang=0;
#foreach our $lang (@DLLANGAVAIL)
#{
#        if ( $lang eq $opt_dllang )
#        {
#                $testlang=1;
#        }
#}
#if ( $testlang==0 )
#{
#	our $opt_dllang="english";
#}

#if ( "$opt_dllang" eq "english" )
#{
	our $DLHELPFILE="$DLDOCDIR/en/helpfile.txt";
	our $DLUSAGEFILE="$DLDOCDIR/en/usage.txt";
	our $DLDATE="2003, sept 15";

	our $DLTXTCANTFIND="I can't find";
	our $DLTXTISCREATED="is created";
	our $DLTXTLANGAVAIL="The available languages are:";
	our $DLTXTAVAIL="The available ports are:";
	our $DLTXTISNTKNOWN="is not known by";
	our $DLTXTMODPL="modify DLPORTLIST\n";
	our $DLTXTHARD="Your attention: this world's very tough!\n";
	our $DLTXTFUNNY="Beware: this world's not very serious!\n";
	our $DLTXTTOTAL="Warning: this world's a total conversion!\n";
	our $DLTXTGAME="This world's played";
	our $DLTXTEP="in the episode";
	our $DLTXTLEV="in the level";
	our $DLTXTMUSIC="This is a music only wad.\n";
	our $DLTXTEDGEBUG="edge is a bit buggy, so be cool.\nAnd it needs .gwa files, so create them.\n";
	our $DLTXTNOREADME="Sorry, no doc available.\n";
	our $DLTXTCOOP="This wad is designed for cooperative play.\n";
	our $DLTXTNOCOOP="This wad is not designed for cooperative play.\n";
	our $DLTXTDM="This wad is designed for deathmatch.\n";
	our $DLTXTNODM="This wad is not designed for deathmatch.\n";
	our $DLTXTHITKEY="Hit Enter key";
#}

if ( $opt_dllang eq "franais" )
{
	our $DLHELPFILE="$DLDOCDIR/fr/helpfile.txt";
	our $DLUSAGEFILE="$DLDOCDIR/fr/usage.txt";
	our $DLDATE="15 septembre 2003";

	our $DLTXTCANTFIND="Je ne peux pas trouver";
	our $DLTXTISCREATED="est cr";
	our $DLTXTLANGAVAIL="Les langues disponibles sont :";
	our $DLTXTAVAIL="Les ports disponibles sont :";
	our $DLTXTISNTKNOWN="n'est pas un port connu par";
	our $DLTXTMODPL="modifiez la variable DLPORTLIST\n";
	our $DLTXTHARD="Mise en garde : ce monde est trs difficile !\n";
	our $DLTXTFUNNY="Attention, ce monde n'est pas srieux !\n";
	our $DLTXTTOTAL="Soyez prvenus, ce monde est une conversion de Doom !\n";
	our $DLTXTGAME="Ce monde se joue";
	our $DLTXTEP="dans l'pisode";
	our $DLTXTLEV="au niveau";
	our $DLTXTMUSIC="Ce fichier ne contient que de la musique.\n";
	our $DLTXTEDGEBUG="edge est un peu bogu alors soyez indulgents.\nEt il ncessite des fichiers .gwa, alors il faut les crer.\n";
	our $DLTXTNOREADME="Dsol, il n'y a pas de doc disponible.\n";
	our $DLTXTCOOP="Ce monde est fait pour le jeu coopratif.\n";
	our $DLTXTNOCOOP="Ce monde n'est pas fait pour le jeu coopratif.\n";
	our $DLTXTDM="Ce monde est fait pour le deathmatch.\n";
	our $DLTXTNODM="Ce monde n'est pas fait pour le deathmatch.\n";
	our $DLTXTHITKEY="Frappez la touche Entre";
}

#if ()			# add your language here
# {
#	our $DLHELPFILE="$DLDOCDIR/
#	our $DLUSAGEFILE="$DLDOCDIR/
#	our $DLTXTCANTFIND="
#	our $DLTXTISCREATED="
#	our $DLTXTLANGAVAIL="
#	our $DLTXTAVAIL="
#	our $DLTXTISNTKNOWN="
#	our $DLTXTMODPL="
#	our $DLTXTHARD="
#	our $DLTXTFUNNY="
#	our $DLTXTTOTAL="
#	our $DLTXTGAME="
#	our $DLTXTEP="
#	our $DLTXTLEV="
#	our $DLTXTMUSIC="
#	our $DLTXTEDGEBUG="
#	our $DLTXTNOREADME="
#	our $DLTXTCOOP="
#	our $DLTXTNOCOOP="
#	our $DLTXTDM="
#	our $DLTXTNODM="
#	our $DLTXTHITKEY="	
# }

if ( $opt_dlmkrc == 1 )
{
	if ( ! -e "$ENV{HOME}/.doomloader/" )
	{
		mkdir $ENV{HOME}.'/.doomloader/';
		print ".doomloader/ $DLTXTISCREATED\n";
	}
	if ( ! -e "$ENV{HOME}/.doomloader/doomloader.rc" )
	{
		system("cp /etc/doomloader/doomloader.rc $ENV{HOME}/.doomloader/");
		print ".doomloader/doomloader.rc $DLTXTISCREATED\n";
	}
	if ( ! -e "$ENV{HOME}/.doomloader/playlist.rc" )
	{
		system("cp /etc/doomloader/playlist.rc $ENV{HOME}/.doomloader/");
		print ".doomloader/playlist.rc $DLTXTISCREATED\n";
	}
	exit;
}

if ( $emptyargv == 1 )
{
	die "$DLTXTCANTFIND $DLUSAGEFILE\n" unless -f $DLUSAGEFILE;
	print `cat $DLUSAGEFILE`;
	exit;
}

if ( $opt_dlhelp == 1 )
{
	die "$DLTXTCANTFIND $DLHELPFILE\n" unless -f $DLHELPFILE;
	die "$DLTXTCANTFIND $DLUSAGEFILE\n" unless -f $DLUSAGEFILE;
	print `cat $DLUSAGEFILE`;
	print `cat $DLHELPFILE`;
	exit;
}

if ( $opt_dlversion == 1 )
{
	print "$DLNAME, version $DLVERSION, $DLDATE\n";
	exit;
}

if ( $opt_dllicense == 1 )
{
	die "$DLTXTCANTFIND $DLLICENSEFILE\n" unless -f $DLLICENSEFILE;
	system("less $DLLICENSEFILE");
	exit;
}

if ( ($opt_dlwadinfo == 1) and ($opt_dlreadme eq " ") )
{
        print "$DLTXTNOREADME";
        exit;
}

if ( ($opt_dlwadinfo == 1) and ($opt_dlreadme ne " ") )
{
        system("cat $opt_dlreadme|less");
        exit;
}


if ( $opt_dllangavail == 1 )
{
	print "$DLTXTLANGAVAIL ";
        foreach our $lang (@DLLANGAVAIL)
        {
                print "$lang ";
        }
        print "\n";
        exit;
}

if ( $opt_dlavail == 1 )
{
	print "$DLTXTAVAIL ";
	foreach our $port (@DLPORTLIST)
	{
		print "$port ";
	}
	print "\n";
	exit;
}

our $portisknown=0;
foreach our $testport (@DLPORTLIST)
{
	if ( $testport eq $opt_dlport )
	{
		$portisknown=1;
	}
}
if ( $portisknown == 0 )
{
        print "$opt_dlport $DLTXTISNTKNOWN $DLNAME,\n";
        print "$DLTXTMODPL";
        exit;
}

if ( $opt_dlmusic == 1 )
{
	print "$DLTXTMUSIC";
}

if ( $opt_dlhard == 1 )
{
	print "$DLTXTHARD";
}

if ( $opt_dlfunny == 1 )
{
        print "$DLTXTFUNNY";
}

if ( $opt_dltotal == 1 )
{
        print "$DLTXTTOTAL";
}

if ( $opt_dlcoop == 1 )
{
	print "$DLTXTCOOP";
}

if ( $opt_dlnocoop == 1 )
{
	print "$DLTXTNOCOOP";
}

if ( $opt_dldm == 1 )
{
        print "$DLTXTDM";
}

if ( $opt_dlnodm == 1 )
{
        print "$DLTXTNODM";
}
		
if ( ($opt_dlep ne " ") || ($opt_dllev ne " ") )
{
	print "$DLTXTGAME ";
	if ($opt_dlep ne " ")
	{
		print "$DLTXTEP $opt_dlep ";
	}
	if ($opt_dllev ne " ")
	{
		print "$DLTXTLEV $opt_dllev";
	}
	print ".\n";
}

print "$opt_dltext\n";

if ( $opt_dlport eq "edge" )
{
	print "$DLTXTEDGEBUG";
	chdir $DLEDGEDIR;
}

if ( ( $opt_dltotal + $opt_dlfunny + $opt_dlhard + $opt_dlmusic + $opt_dlcoop + $opt_dlnocoop + $opt_dldm + $opt_dlnodm > 0 ) || ( $opt_dltext ne " " ) || ($opt_dlep ne " ") || ($opt_dllev ne " ") || ($opt_dlport eq "edge") )
{
	print "$DLTXTHITKEY";
	getc();
}

# I'd like to manage the display type (tty or X) with $DISPLAY
# J'aimerais grer le type d'affichage (console ou X) avec $DISPLAY

exec("$opt_dlport @ARGV");

# we launch the port with the options not used by doomloader
# on lance le port avec les options non utilises

